/************************************************************/
/* PROJECT NAME: FIR	                                    */
/* Project:      LPC2100 Training course                    */
/* Engineer:     T Martin       tmartin@hitex.co.uk         */
/* Filename:     main.c                                     */
/* Language:     C                      	                */
/* Compiler:     Keil ARM	V2.00b		                    */
/* Assembler:    					                        */
/*                                                          */
/************************************************************/
/* COPYRIGHT: Hitex UK Ltd 		2005						*/
/* LICENSE:   THIS VERSION CREATED FOR FREE DISTRIBUTION	*/
/************************************************************/
/* Function:                                                */
/*                                                          */
/* Example Interrupt program for LPC2100           			*/
/*															*/
/* Demonstrates configuring a function as an ISR			*/
/*															*/	
/* Oscillator frequency 12.000 Mhz							*/
/* Target board Keil MCB2100								*/
/************************************************************/


#include <LPC21xx.H>
void FIQ_Handler (void) __fiq;	   //declare FIQ ISR
void initFiq (void);

void main (void)
{

initFiq();											   //Initilise the Fast interrupt source
IOCLR1 			= 0x00FF0000;						   //clear the LED pins
while(1)
{
;								  						//Loop here forever
}

}

void FIQ_Handler (void)	__fiq
{
IOSET1 			= 0x00FF0000;								//Set the LED pins
EXTINT  		= 0x00000002;								//Clear the peripheral interrupt flag

}

void initFiq(void) 
{
IODIR1			= 0x00FF0000;							//Set the LED pins as outputs
PINSEL0 		= 0x20000000;							//Enable the EXTINT1 interrupt
VICIntSelect 	= ;										//Enable a Vic Channel as FIQ
VICIntEnable	= 0x00008000;		
}
